Ext.data.JsonP.sol_common_ix_services_ChildrenDataCollector({"tagname":"class","name":"sol.common.ix.services.ChildrenDataCollector","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.services.ChildrenDataCollector.js","href":"sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector"}],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.ServiceBase","mixins":[],"requires":[],"uses":[],"members":[{"name":"endLevel","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataCollector","id":"cfg-endLevel","meta":{}},{"name":"filter","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataCollector","id":"cfg-filter","meta":{}},{"name":"formatter","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataCollector","id":"cfg-formatter","meta":{"required":true}},{"name":"mainParent","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataCollector","id":"cfg-mainParent","meta":{}},{"name":"maskName","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataCollector","id":"cfg-maskName","meta":{}},{"name":"maskNames","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataCollector","id":"cfg-maskNames","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.ServiceBase","id":"cfg-objId","meta":{}},{"name":"objKeys","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataCollector","id":"cfg-objKeys","meta":{}},{"name":"parentId","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataCollector","id":"cfg-parentId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"returnDataDefinition","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataCollector","id":"cfg-returnDataDefinition","meta":{}},{"name":"sordKeys","tagname":"cfg","owner":"sol.common.ix.services.ChildrenDataCollector","id":"cfg-sordKeys","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"collectorVersion","tagname":"property","owner":"sol.common.ix.services.ChildrenDataCollector","id":"property-collectorVersion","meta":{"private":true}},{"name":"data","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-data","meta":{}},{"name":"dataDefinition","tagname":"property","owner":"sol.common.ix.services.ChildrenDataCollector","id":"property-dataDefinition","meta":{}},{"name":"logger","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-logger","meta":{"protected":true}},{"name":"maxFind","tagname":"property","owner":"sol.common.ix.services.ChildrenDataCollector","id":"property-maxFind","meta":{}},{"name":"sordKeyMap","tagname":"property","owner":"sol.common.ix.services.ChildrenDataCollector","id":"property-sordKeyMap","meta":{"private":true}},{"name":"totalCount","tagname":"property","owner":"sol.common.ix.services.ChildrenDataCollector","id":"property-totalCount","meta":{}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addDocMaskData","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"method-addDocMaskData","meta":{"private":true}},{"name":"addLocale","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"method-addLocale","meta":{"private":true}},{"name":"buildDocMaskData","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"method-buildDocMaskData","meta":{"private":true}},{"name":"checkMandatoryProperties","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-checkMandatoryProperties","meta":{"protected":true}},{"name":"collectChildren","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"method-collectChildren","meta":{"private":true}},{"name":"collectSord","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"method-collectSord","meta":{"private":true}},{"name":"computeSordElementSelector","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"method-computeSordElementSelector","meta":{"private":true}},{"name":"containsClassName","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-containsClassName","meta":{}},{"name":"execute","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"method-execute","meta":{}},{"name":"getSordFormatter","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"method-getSordFormatter","meta":{"private":true}},{"name":"getTypeConstants","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"method-getTypeConstants","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"method-initialize","meta":{"private":true}},{"name":"prefillMetadata","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-prefillMetadata","meta":{"protected":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-process","meta":{"abstract":true}},{"name":"RF_sol_common_services_ChildrenDataCollector","tagname":"method","owner":"sol.common.ix.services.ChildrenDataCollector","id":"static-method-RF_sol_common_services_ChildrenDataCollector","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.services.ChildrenDataCollector","short_doc":"Collects all child sords for a given parent in an optimized way. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.ServiceBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a><div class='subclass '><strong>sol.common.ix.services.ChildrenDataCollector</strong></div></div></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector' target='_blank'>sol.common.ix.services.ChildrenDataCollector.js</a></div></pre><div class='doc-contents'><p>Collects all child sords for a given parent in an optimized way.</p>\n\n<p>This should be used by dashboards if a larger amount of Sords should be retrieved. In addition information of\nrequired keyword forms and the user locale is returned.</p>\n\n<p>Please gather information carefully. Only the required objKeys and sordKeys should be collected by this service due\nto performance improvements. e.g.</p>\n\n<p>Collecting 10,000 invoices for the invoice dashboard takes ~15s and creates ~80MB of traffic using the IX JS-API since\ndeserializing objects might be expensive. Since only a view information is required this service brings down\nthe execution time to ~5-6s and reduces data traffic to ~6MB. This is done by creating a minimized json-data structure\nwith the help of a string builder.</p>\n\n<h1>Example</h1>\n\n<p>By default StatisticSord formatter is used for generating objects that are optimized for statistical\noperations. Refer to <a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a> for more information.</p>\n\n<pre><code>var result = <a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_common_services_ChildrenDataCollector\", {\n  parentId: '1213',\n  objKeys: [\"INVOICE_DATE\", \"INVOICE_AMOUNT\"]\n});\n</code></pre>\n\n<h1>Result</h1>\n\n<pre><code>{\n  version: '1',\n  formatter: '<a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a>',\n  locale: {\n    language: 'de',\n    dateFormat: 'dd.MM.yyyy',\n    decimalSeperator: ',',\n    groupingSeperator: '.'\n  },\n  sords: [{\n   id: '5669',\n   name: 'Invoice 123',\n   O_INVOICE_DATE: '20151202'\n  }, {\n    // more sords ...\n  }],\n  docMasks: {\n    'Incoming Invoice': {\n      fields: {\n        INVOICE_DATE: { name: 'Invoice Date', type: 'text' }\n      }\n    }\n  }\n}\n</code></pre>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-formatter' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-cfg-formatter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-cfg-formatter' class='name expandable'>formatter</a> : Class<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>Sord object formatter implementation. ...</div><div class='long'><p>Sord object formatter implementation.</p>\n\n<p>e.g. <code><a href=\"#!/api/sol.common.ObjectFormatter.StatisticSord\" rel=\"sol.common.ObjectFormatter.StatisticSord\" class=\"docClass\">sol.common.ObjectFormatter.StatisticSord</a></code> or <code><a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">sol.common.ObjectFormatter.TemplateSord</a></code></p>\n<p>Defaults to: <code>&quot;sol.common.ObjectFormatter.StatisticSord&quot;</code></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-endLevel' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-cfg-endLevel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-cfg-endLevel' class='name expandable'>endLevel</a> : int<span class=\"signature\"></span></div><div class='description'><div class='short'>Search child objects up to this level below parentId. ...</div><div class='long'><p>Search child objects up to this level below parentId.</p>\n\n<p>Please note that recursively collecting child nodes is expensive and should be handled with care.</p>\n\n<p>A value of 0 or 1 means, that only the sub entries directly under the parent are included.\nSet this value to -1, to search over all levels.\nIn this case the level is internally constrained to 32 to avoid an endless loop,\nif the tree under the parent contains recursive references.</p>\n<p>Defaults to: <code>1</code></p></div></div></div><div id='cfg-filter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-cfg-filter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-cfg-filter' class='name expandable'>filter</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>List of metadata that limit search results. ...</div><div class='long'><p>List of metadata that limit search results.</p>\n\n<p>This limits search results to a given list of metadata. This list is passed as an FindByIndex ObjKey-Array while\ncollecting search results.</p>\n\n<pre><code>filter: [{ key: 'INVOICE_DATE', val: 'x*' }],\n</code></pre>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='cfg-mainParent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-cfg-mainParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-cfg-mainParent' class='name expandable'>mainParent</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Return no references ...</div><div class='long'><p>Return no references</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-maskName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-cfg-maskName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-cfg-maskName' class='name expandable'>maskName</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Restricts search results to a given keywording mask</p>\n</div><div class='long'><p>Restricts search results to a given keywording mask</p>\n</div></div></div><div id='cfg-maskNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-cfg-maskNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-cfg-maskNames' class='name expandable'>maskNames</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Restricts search results to the given keywording masks</p>\n</div><div class='long'><p>Restricts search results to the given keywording masks</p>\n</div></div></div><div id='cfg-objId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-objKeys' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-cfg-objKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-cfg-objKeys' class='name expandable'>objKeys</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>List of required objKeys. ...</div><div class='long'><p>List of required objKeys.</p>\n\n<p>This only returns the given objKeys. This is required in order to limit traffic for not required keys.</p>\n\n<pre><code>objKeys: [\"INVOICE_DATE\", \"INVOICE_AMOUNT\"],\n</code></pre>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='cfg-parentId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-cfg-parentId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-cfg-parentId' class='name expandable'>parentId</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>id of the parent element (guid, objId or archivepath)</p>\n</div><div class='long'><p>id of the parent element (guid, objId or archivepath)</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-returnDataDefinition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-cfg-returnDataDefinition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-cfg-returnDataDefinition' class='name expandable'>returnDataDefinition</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>If true, the service returns the data definition for the object, which is necessary for the convertion to XML. ...</div><div class='long'><p>If <code>true</code>, the service returns the data definition for the object, which is necessary for the convertion to XML.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-sordKeys' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-cfg-sordKeys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-cfg-sordKeys' class='name expandable'>sordKeys</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>List of required sord keys. ...</div><div class='long'><p>List of required sord keys.</p>\n\n<p>This only returns the given sord keys. This is required in order to limit traffic for not required keys.</p>\n\n<pre><code>sordKeys: [\"id\", \"guid\", \"name\", \"desc\"],\n</code></pre>\n<p>Defaults to: <code>[&quot;id&quot;, &quot;name&quot;]</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-collectorVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-property-collectorVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-property-collectorVersion' class='name expandable'>collectorVersion</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;1.00.000&quot;</code></p></div></div></div><div id='property-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-data' class='name expandable'>data</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div><div class='long'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div></div></div><div id='property-dataDefinition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-property-dataDefinition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-property-dataDefinition' class='name expandable'>dataDefinition</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>for xml transformation\nThis contains the data definition for the result if json objects should be transformed to XML. ...</div><div class='long'><p>for xml transformation\nThis contains the data definition for the result if json objects should be transformed to XML.</p>\n<p>Defaults to: <code>{rootElementName: &quot;data&quot;, dataProperties: [&quot;sord&quot;, &quot;sords&quot;], arrayElementTagNames: {sords: &quot;sord&quot;}}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the service</p>\n</div><div class='long'><p>The logger for the service</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-maxFind' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-property-maxFind' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-property-maxFind' class='name expandable'>maxFind</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Amount of sords that is collected in one step. ...</div><div class='long'><p>Amount of sords that is collected in one step.\nThis is used by the FindFirstSords, FindNextSords function calls.</p>\n<p>Defaults to: <code>1000</code></p></div></div></div><div id='property-sordKeyMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-property-sordKeyMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-property-sordKeyMap' class='name expandable'>sordKeyMap</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-totalCount' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-property-totalCount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-property-totalCount' class='name expandable'>totalCount</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>The search is terminated if this number of objects is found. ...</div><div class='long'><p>The search is terminated if this number of objects is found. If the number of results should not be constrained,\nset this value to 232-1 = 2147483647 (maximum value of a positive 32bit integer minus 1).</p>\n\n<p>Please note that collecting huge amounts of data might lead to performance issues.</p>\n<p>Defaults to: <code>10000</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addDocMaskData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-method-addDocMaskData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-method-addDocMaskData' class='name expandable'>addDocMaskData</a>( <span class='pre'>maskName</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Adds document mask data ...</div><div class='long'><p>Adds document mask data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addLocale' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-method-addLocale' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-method-addLocale' class='name expandable'>addLocale</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-buildDocMaskData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-method-buildDocMaskData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-method-buildDocMaskData' class='name expandable'>buildDocMaskData</a>( <span class='pre'>docMaskName</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Builds the document mask data ...</div><div class='long'><p>Builds the document mask data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>docMaskName</span> : String<div class='sub-desc'><p>Document mask name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkMandatoryProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-checkMandatoryProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-checkMandatoryProperties' class='name expandable'>checkMandatoryProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Checks if all mandatory properties have been set. ...</div><div class='long'><p>Checks if all mandatory properties have been set.</p>\n</div></div></div><div id='method-collectChildren' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-method-collectChildren' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-method-collectChildren' class='name expandable'>collectChildren</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-collectSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-method-collectSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-method-collectSord' class='name expandable'>collectSord</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-computeSordElementSelector' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-method-computeSordElementSelector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-method-computeSordElementSelector' class='name expandable'>computeSordElementSelector</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Computes a SordZ selector for information that is required. ...</div><div class='long'><p>Computes a SordZ selector for information that is required.</p>\n</div></div></div><div id='method-containsClassName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-containsClassName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-containsClassName' class='name expandable'>containsClassName</a>( <span class='pre'>classNames</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether an array contains the class name ...</div><div class='long'><p>Checks wether an array contains the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classNames</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-execute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-method-execute' class='name expandable'>execute</a>( <span class='pre'></span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Starts the collection of the desired data ...</div><div class='long'><p>Starts the collection of the desired data</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSordFormatter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-method-getSordFormatter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-method-getSordFormatter' class='name expandable'>getSordFormatter</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTypeConstants' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-method-getTypeConstants' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-method-getTypeConstants' class='name expandable'>getTypeConstants</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-method-initialize\" rel=\"sol.common.ix.ServiceBase-method-initialize\" class=\"docClass\">sol.common.ix.ServiceBase.initialize</a></p></div></div></div><div id='method-prefillMetadata' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-prefillMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-prefillMetadata' class='name expandable'>prefillMetadata</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Initializes the metadata of an element (defined by objId) from the internal data object. ...</div><div class='long'><p>Initializes the metadata of an element (defined by <code>objId</code>) from the internal <code>data</code> object.</p>\n\n<p>The <code>data</code> property has to be in a specific <a href=\"#!/api/sol.common.ix.ServiceBase-property-data\" rel=\"sol.common.ix.ServiceBase-property-data\" class=\"docClass\">form</a>.\nIf there is no data object no prefilling will be performed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of services' process. ...</div><div class='long'><p>Implementation of services' process. This function must be implemented by the child class and should contain the logic of the function module.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_services_ChildrenDataCollector' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.ChildrenDataCollector'>sol.common.ix.services.ChildrenDataCollector</span><br/><a href='source/sol.common.ix.services.ChildrenDataCollector.html#sol-common-ix-services-ChildrenDataCollector-static-method-RF_sol_common_services_ChildrenDataCollector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.ChildrenDataCollector-static-method-RF_sol_common_services_ChildrenDataCollector' class='name expandable'>RF_sol_common_services_ChildrenDataCollector</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});